{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 09.10.98 - 13:38:44 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  MMObj,
  MMUtils,
  MMCstDlg,
  MMDesign,
  MMWave,
  MMWavOut,
  MMDIBCv,
  MMLevel,
  MMConect,
  MMDSPObj,
  MMWavIn,
  MMRingBf,
  MMHTimer,
  MMSlider,
  MMSpectr,
  MMHook,
  MMWPlay, ExtCtrls;

type
  TForm1 = class(TForm)
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    MMConnector2: TMMConnector;
    MMDesigner1: TMMDesigner;
    Label1: TLabel;
    StopBtn: TButton;
    PlayBtn: TButton;
    OpenDialog: TMMWaveOpenDialog;
    Timer: TMMHiTimer;
    btnForw: TButton;
    WavePlayer: TMMWavePlayer;
    btnBack: TButton;
    SeekTimer: TTimer;
    procedure PlayBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerTimer(Sender: TObject);
    procedure WavePlayerStop(Sender: TObject);
    procedure WavePlayerStart(Sender: TObject);
    procedure SeekTimerTimer(Sender: TObject);
    procedure btnBackMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btnSeekMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btnForwMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    Playing: Boolean;
    Direction: integer;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.StopBtnClick(Sender: TObject);
begin
   { close and stop all devices }
   WavePlayer.Stop;
end;

procedure TForm1.PlayBtnClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      WavePlayer.Wave.FileName := OpenDialog.FileName;

      WavePlayer.TimeFormat := tfMillisecond;

      Playing := True;


      { start playing }
      WavePlayer.Play;
   end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { don't forgot to close the devices at the end }
   WavePlayer.Stop;
end;

procedure TForm1.TimerTimer(Sender: TObject);
var
   Time: Longint;
begin
   if Playing then
   begin
      Time := WavePlayer.Position;
      Label1.Caption := TimeToString(Time);
   end;
end;

procedure TForm1.WavePlayerStop(Sender: TObject);
begin
   Playing := False;
   Timer.Enabled := False;
   SeekTimer.Enabled:= False;

   btnBack.Enabled := False;
   btnForw.Enabled := False;
   StopBtn.Enabled := False;
   PlayBtn.Enabled := True;
end;

procedure TForm1.WavePlayerStart(Sender: TObject);
begin
   StopBtn.Enabled := True;
   PlayBtn.Enabled := False;
   btnBack.Enabled := True;
   btnForw.Enabled := True;
   Timer.Enabled   := True;
end;

procedure TForm1.SeekTimerTimer(Sender: TObject);
var
   NewPos: Longint;
begin
   NewPos := WavePlayer.Position+(1000*Direction);
   if (NewPos >= 0) and (NewPos <= WavePlayer.Wave.DataSize-1000) then
      WavePlayer.Position := NewPos
   else
      SeekTimer.Enabled := False;
end;

procedure TForm1.btnBackMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   Direction := -1;
   SeekTimer.Enabled := True;
end;

procedure TForm1.btnForwMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   Direction := 1;
   SeekTimer.Enabled := True;
end;

procedure TForm1.btnSeekMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   SeekTimer.Enabled := False;
end;

end.
